#ifndef ZMODELER_STRUCT_TVERTEX_H_INCLUDED
#define ZMODELER_STRUCT_TVERTEX_H_INCLUDED

/****************************************
  3D Vertex
****************************************/

class DllExport tVertex : public tAbstract
{
public:
//-----------------
//  data members
  float X,Y,Z;
  DWORD  Color;  //per vertex color currently unused;

//-----------------
//  construction

  tVertex();
  tVertex(tPOINT p);
  tVertex(tPOINT p, DWORD col);
  tVertex(tPOINT p, BYTE r,BYTE g, BYTE b, BYTE a=255);
  
//-----------------
//  functions;
  float DistanceTo(float _x, float _y, float _z); //distance from vertex to supplied point
  float DistanceTo(tPOINT *p);  //distance from vertex to supplied point

  //moves vertex to supplied offset if it's marked/selected
  virtual void MoveOffset(tPOINT *Offset, BOOL MarkedMode, BOOL Selection);
  //multiplies coordinates to supplied values if vertex is marked/selected
  virtual void Scale(float XScale, float YScale, float ZScale, BOOL MarkedMode, BOOL Selection);
  //drawes the vertex on supplied CDC object.
  virtual void Draw(  CDC* pDC,
            z3dViewDescriptor* pView,
            BOOL DrawMarked,
            BOOL DrawExtraSize);
  //TRUE if cover factor (Marked) of vertex has changed
  virtual BOOL Cover(  POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius);
  //TRUE if vertex is covered with supplied loc POINT
  virtual BOOL Covered(  POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius);
//-----------------
//  operators
  tVertex& operator+=(const tPOINT& p);
  tVertex& operator+=(const tVertex& p);
  tVertex& operator-=(const tPOINT& p);
  tVertex& operator-=(const tVertex& p);
  tVertex& operator*=(const float val);
  tVertex& operator= (const tPOINT& p);
  tVertex& operator= (const tVertex& v);
  operator==(const tPOINT& p);
  operator==(const tVertex& v);
  operator!=(const tPOINT& p);
  operator!=(const tVertex& v);
  friend tPOINT operator+(const tVertex lv, const tPOINT rp);
  friend tPOINT operator-(const tVertex lv, const tPOINT rp);
  friend tPOINT operator+(const tPOINT lp, const tVertex rv);
  friend tPOINT operator-(const tPOINT lp, const tVertex rv);
  operator tPOINT();
};

#endif

